/*
 * Decompiled with CFR 0.152.
 */
package com.quantumdata.imgcontrol;

import com.quantumdata.widgets.QDLabel;
import com.quantumdata.widgets.QDPanel;
import com.quantumdata.widgets.QDStdUI;
import com.quantumdata.widgets.QDTitledBorder;
import java.awt.Color;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.util.Hashtable;
import javax.swing.JLabel;
import javax.swing.JSlider;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.EventListenerList;

class ColorControl
extends QDPanel
implements FocusListener {
    private static final long serialVersionUID = 1L;
    private String m_name;
    private JSlider[] m_comps = new JSlider[3];
    private JSpinner[] m_spin = new JSpinner[3];
    private JTextField[] m_vals = new JTextField[3];
    private JLabel m_clr;
    private boolean m_grayScaleMode = false;
    private EventListenerList m_listenerList = new EventListenerList();
    private ChangeEvent m_changeEvent;
    private boolean m_updating = false;

    public ColorControl(String string) {
        int n;
        this.m_name = string;
        this.m_changeEvent = new ChangeEvent(this);
        GridBagLayout gridBagLayout = new GridBagLayout();
        this.setBorder(new QDTitledBorder(this.m_name));
        this.setLayout(gridBagLayout);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 11;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(3, 5, 3, 5);
        Hashtable<Integer, JLabel> hashtable = new Hashtable<Integer, JLabel>();
        Integer[] integerArray = new Integer[9];
        Font font = new Font("SansSerif", 0, 10);
        for (n = 0; n <= 8; ++n) {
            int n2 = n * 512;
            if (n2 == 4096) {
                --n2;
            }
            integerArray[n] = n2;
            double d = (double)n / 8.0 * 100.0;
            JLabel jLabel = new JLabel(String.format("%1$5.1f%%", d));
            jLabel.setForeground(QDStdUI.getActionForeground());
            jLabel.setFont(font);
            hashtable.put(integerArray[n], jLabel);
        }
        this.m_clr = new JLabel("   ");
        this.m_clr.setBackground(Color.black);
        this.m_clr.setOpaque(true);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 3;
        gridBagLayout.setConstraints(this.m_clr, gridBagConstraints);
        this.add(this.m_clr);
        gridBagConstraints.gridwidth = 1;
        String[] stringArray = new String[]{"Red", "Green", "Blue"};
        gridBagConstraints.gridwidth = 1;
        for (n = 0; n < 3; ++n) {
            ColorListener colorListener = new ColorListener(n);
            int n3 = 1;
            this.m_comps[n] = new JSlider(1, 0, 4095, 0);
            this.m_comps[n].setPaintLabels(true);
            this.m_comps[n].setPaintTrack(true);
            this.m_comps[n].setPaintTrack(true);
            this.m_comps[n].setLabelTable(hashtable);
            this.m_comps[n].setBackground(QDStdUI.getBackground());
            this.m_comps[n].addChangeListener(colorListener);
            gridBagConstraints.gridx = n;
            gridBagConstraints.gridy = n3++;
            QDLabel qDLabel = new QDLabel(stringArray[n]);
            qDLabel.setHorizontalAlignment(0);
            gridBagLayout.setConstraints(qDLabel, gridBagConstraints);
            this.add(qDLabel);
            gridBagConstraints.gridx = n;
            gridBagConstraints.gridy = n3++;
            gridBagLayout.setConstraints(this.m_comps[n], gridBagConstraints);
            this.add(this.m_comps[n]);
            QDPanel qDPanel = new QDPanel();
            this.m_vals[n] = new JTextField(4);
            this.m_vals[n].setText("0");
            this.m_vals[n].addActionListener(colorListener);
            qDPanel.add(this.m_vals[n]);
            this.m_spin[n] = new JSpinner();
            this.m_spin[n].setEditor(this.m_vals[n]);
            this.m_spin[n].addChangeListener(colorListener);
            qDPanel.add(this.m_spin[n]);
            gridBagConstraints.gridx = n;
            gridBagConstraints.gridy = n3++;
            gridBagLayout.setConstraints(qDPanel, gridBagConstraints);
            this.add(qDPanel);
            this.m_vals[n].addFocusListener(this);
        }
    }

    public void addChangeListener(ChangeListener changeListener) {
        this.m_listenerList.add(ChangeListener.class, changeListener);
    }

    public void setColor(String string) {
        String[] stringArray = string.split(", ");
        if (stringArray.length != 3) {
            return;
        }
        this.m_updating = true;
        for (int i = 0; i < 3; ++i) {
            int n = Integer.parseInt(stringArray[i]);
            this.m_spin[i].setValue(new Integer(n));
            double d = (double)n / 4095.0 * 100.0;
            this.m_vals[i].setText(String.format("%1$.2f", d));
            this.m_comps[i].setValue(n);
        }
        this.showColor();
        this.setGrayScaleMode(this.m_grayScaleMode);
        this.m_updating = false;
    }

    public String getColorText() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.m_comps[0].getValue());
        stringBuffer.append(", ");
        stringBuffer.append(this.m_comps[1].getValue());
        stringBuffer.append(", ");
        stringBuffer.append(this.m_comps[2].getValue());
        return stringBuffer.toString();
    }

    public void setGrayScaleMode(boolean bl) {
        this.m_grayScaleMode = bl;
        if (this.m_grayScaleMode) {
            int n = this.m_comps[0].getValue();
            n += this.m_comps[1].getValue();
            n += this.m_comps[2].getValue();
            this.setValue(0, n /= 3);
        }
    }

    public boolean getGrayScaleMode() {
        return this.m_grayScaleMode;
    }

    protected void fireChangeEvent() {
        Object[] objectArray;
        for (Object object : objectArray = this.m_listenerList.getListenerList()) {
            if (!(object instanceof ChangeListener)) continue;
            ((ChangeListener)object).stateChanged(this.m_changeEvent);
        }
    }

    private void showColor() {
        int n = this.m_comps[0].getValue() / 16;
        int n2 = this.m_comps[1].getValue() / 16;
        int n3 = this.m_comps[2].getValue() / 16;
        this.m_clr.setBackground(new Color(n, n2, n3));
    }

    protected void setValue(int n, int n2) {
        if (n2 < 0) {
            n2 = 0;
        } else if (n2 > 4095) {
            n2 = 4095;
        }
        this.m_spin[n].setValue(new Integer(n2));
        double d = (double)n2 / 4095.0 * 100.0;
        String string = String.format("%1$.2f", d);
        this.m_vals[n].setText(string);
        this.m_comps[n].setValue(n2);
        if (this.m_grayScaleMode) {
            for (int i = 0; i < 3; ++i) {
                if (i == n) continue;
                this.m_spin[i].setValue(new Integer(n2));
                this.m_vals[i].setText(string);
                this.m_comps[i].setValue(n2);
            }
        }
        this.showColor();
        this.fireChangeEvent();
    }

    public void focusGained(FocusEvent focusEvent) {
        if (focusEvent.getSource() instanceof JTextField) {
            ((JTextField)focusEvent.getSource()).selectAll();
        }
    }

    public void focusLost(FocusEvent focusEvent) {
    }

    private class ColorListener
    implements ChangeListener,
    ActionListener {
        private int m_id;

        public ColorListener(int n) {
            this.m_id = n;
        }

        public void stateChanged(ChangeEvent changeEvent) {
            if (ColorControl.this.m_updating) {
                return;
            }
            ColorControl.this.m_updating = true;
            int n = changeEvent.getSource() instanceof JSlider ? ColorControl.this.m_comps[this.m_id].getValue() : ((Integer)ColorControl.this.m_spin[this.m_id].getValue()).intValue();
            ColorControl.this.setValue(this.m_id, n);
            ColorControl.this.m_updating = false;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (ColorControl.this.m_updating) {
                return;
            }
            ColorControl.this.m_updating = true;
            double d = Double.parseDouble(ColorControl.this.m_vals[this.m_id].getText());
            int n = (int)Math.round(d / 100.0 * 4095.0);
            ColorControl.this.setValue(this.m_id, n);
            ColorControl.this.m_vals[this.m_id].selectAll();
            ColorControl.this.m_updating = false;
        }
    }
}

